L_AND      START
****************************************************************
*
* L_AND    Long bit routines
* L_OR
* L_EOR
*
* stack:   longword
*          longmask
*
* a/x:     longword AND longmask
*   y:     trashed
*
* L_BITSTATE
*
* stack:   longword
*          wordNbit (0 based: only values of 0 through 31 are valid)
*
* a:       boolean  TRUE (-1) if bit was set, FALSE (0) if bit was clear.
* x/y:     trashed
*
* Marc Wolfgram 3Nov90
*
****************************************************************
           phb
           phk                          s123456789012
           plb                          ^BrtlMaskLong

           lda      11,s                grab the longword
           tax
           lda      9,s
           tay

           pla                          put our frame shit on the top
           sta      7,s
           pla                          s12345678
           sta      7,s                 ^MaskBrtl

           txa                          complete the AND operation
           and      3,s
           tax
           tya
           and      1,s

           ply                          trash the mask and say bye
           ply
           plb
           rtl

****************************************************************
L_OR       ENTRY
           phb
           phk                          s123456789012
           plb                          ^BrtlMaskLong

           lda      11,s                grab the longword
           tax
           lda      9,s
           tay

           pla                          put our frame shit on the top
           sta      7,s
           pla                          s12345678
           sta      7,s                 ^MaskBrtl

           txa                          complete the OR operation
           ora      3,s
           tax
           tya
           ora      1,s

           ply                          trash the mask and say bye
           ply
           plb
           rtl

****************************************************************
L_EOR      ENTRY
           phb
           phk                          s123456789012
           plb                          ^BrtlMaskLong

           lda      11,s                grab the longword
           tax
           lda      9,s
           tay

           pla                          put our frame shit on the top
           sta      7,s
           pla                          s12345678
           sta      7,s                 ^MaskBrtl

           txa                          complete the EOR operation
           eor      3,s
           tax
           tya
           eor      1,s

           ply                          trash the mask and say bye
           ply
           plb
           rtl

****************************************************************
L_BITSTATE ENTRY
           phb
           phk                          s1234567890
           plb                          ^BrtlBnLong

           lda      9,s
           tax
           lda      7,s
           tay

           lda      5,s                 grab the bit number and determine word
           cmp      #16
           blt      lo_word

           lsr      a                   make hi_bit equivalent lo
           txy                          swap hi_word into lo_word

lo_word    tax                          save bit number

           pla                          put our frame shit on the top
         p sta      5,s
           pla                          s123456
           sta      5,s                 ^bnBrtl

           lda      #0                  create a word mask
           sec
bit_loop   rol      a
           dex
           bne      bit_loop
           sta      1,s                 ^wmBrtl

           tya                          complete the bit test
           and      1,s
           beq      bit_done            FALSE

           lda      #-1                 TRUE

bit_done   ply                          trash the mask and say bye
           plb
           rtl

           END
